//==========================================================
// Espers.js
//==========================================================

//==========================================================
// This script is for the building a management of the items and they're stats
//==========================================================

//==========================================================
// Requires scripts:
// NONE
//==========================================================

function esper(name, info, mpCost, levelUp)
{
  this.name = name;
  this.info = info;
  this.mpCost = mpCost;
  this.levelUp = levelUp || "";
  this.spells = [];
  this.epuipTo = undefined;
}

function esperSpell(spell, learnRate)
{
  this.spell = spell;
  this.learnRate = learnRate
}

//==========================================================
// Variables
//==========================================================
var espers = new Array(); // Create array to store the items
//==========================================================
{
  espers[0] = new esper("Ramuh", "Lightning-elemental attack", 25, "Stamina+1");
  espers[0].spells = [new esperSpell(2, 10), new esperSpell(7, 2), new esperSpell(3, 5)];
  
  espers[1] = new esper("Kirin", "Gradually recovers HP", 18);
  espers[1].spells = [new esperSpell(24, 5), new esperSpell(25, 1), new esperSpell(31, 3), new esperSpell(29, 4), new esperSpell(33, 5)];
  
  espers[2] = new esper("Siren", "Silences enemies", 16, "HP + 10%");
  espers[2].spells = [new esperSpell(38, 10), new esperSpell(36, 8), new esperSpell(34, 7), new esperSpell(0, 6)];
  
  espers[3] = new esper("Stray", "Confuses enemies", 28, "Magic Power+1");
  espers[3].spells = [new esperSpell(39, 7), new esperSpell(44, 5), new esperSpell(43, 2)];
  
  espers[4] = new esper("Ifrit", "Fire-elemental attack", 26, "Vigor+1");
  espers[4].spells = [new esperSpell(0, 10), new esperSpell(5, 5), new esperSpell(4, 1)];
  
  espers[5] = new esper("Shiva", "Ice-elemental attack", 27);
  espers[5].spells = [new esperSpell(1, 10), new esperSpell(6, 5), new esperSpell(35, 4), new esperSpell(50, 4), new esperSpell(24, 3)];
  
  espers[6] = new esper("Unicorn", "Casts Remedy on the party", 30);
  espers[6].spells = [new esperSpell(25, 4), new esperSpell(30, 3), new esperSpell(53, 2), new esperSpell(37, 1), new esperSpell(46, 1)];
  
  espers[7] = new esper("Manduin", "Non-elemental attack", 44, "Magic Power+1");
  espers[7].spells = [new esperSpell(5, 3), new esperSpell(6, 3), new esperSpell(7, 3)];
  
  espers[8] = new esper("Shoat", "Petrifies enemies", 45, "Hp + 10%");
  espers[8].spells = [new esperSpell(8, 8), new esperSpell(12, 5), new esperSpell(13, 2)];
  
  espers[9] = new esper("Phantom", "Makes the party invisible", 38, "MP + 10%");
  espers[9].spells = [new esperSpell(42, 3), new esperSpell(47, 3), new esperSpell(16, 5)];
  
  espers[10] = new esper("Carbunkl", "Casts Reflect on party", 36);
  espers[10].spells = [new esperSpell(45, 5), new esperSpell(40, 3), new esperSpell(46, 2), new esperSpell(37, 2), new esperSpell(51, 2)];
  
  espers[11] = new esper("Bismark", "Water-elemental attack", 50, "Vigor+2");
  espers[11].spell = [new esperSpell(0, 20), new esperSpell(1, 20), new esperSpell(2, 20), new esperSpell(27, 2)];
  
  espers[12] = new esper("Golem", "Protects the party", 33, "Stamina+2");
  espers[12].spells = [new esperSpell(37, 5), new esperSpell(41, 5), new esperSpell(25, 5)];
  
  espers[13] = new esper("ZoneSeek", "Casts Shell on party", 30, "Magic Power+1");
  espers[13].spells = [new esperSpell(35, 20), new esperSpell(50, 15), new esperSpell(46, 5)];
  
  espers[14] = new esper("Sraphim", "Recovers HP", 40);
  espers[14].spells = [new esperSpell(27, 5), new esperSpell(25, 8), new esperSpell(24, 20), new esperSpell(25, 31), new esperSpell(30, 4)];
  
  espers[15] = new esper("Palidor", "Party members use a Jump attack", 61);
  espers[15].spells = [new esperSpell(40, 20), new esperSpell(34, 20), new esperSpell(48, 2), new esperSpell(49, 2), new esperSpell(43, 5)];
  
  espers[16] = new esper("Fenrir", "Makes multi. images of the party", 70, "MP + 30%");
  espers[16].spells = [new esperSpell(25, 51), new esperSpell(18, 5), new esperSpell(41, 3)];
  
  espers[17] = new esper("Tritoch", "Ice/Fire/Lightning 3-way attack", 68, "Magic Power+1");
  espers[17].spells = [new esperSpell(9, 1), new esperSpell(10, 1), new esperSpell(11, 1)];
  
  espers[18] = new esper("Terrato", "Earth-elemental attack", 40, "HP + 30%");
  espers[18].spells = [new esperSpell(21, 3), new esperSpell(17, 1), new esperSpell(22, 1)];
  
  espers[19] = new esper("Starlet", "Recovers HP", 74, "Stamina+2");
  espers[19].spells = [new esperSpell(24, 25), new esperSpell(25, 16), new esperSpell(26, 1), new esperSpell(31, 20), new esperSpell(30, 20)];
  
  espers[20] = new esper("Alexandr", "Mystic purity attack", 90);
  espers[20].spells = [new esperSpell(14, 2), new esperSpell(46, 10), new esperSpell(37, 10), new esperSpell(53, 10), new esperSpell(30, 15)];
  
  espers[21] = new esper("Phoenix", "Recovers battle status", 110);
  espers[21].spells = [new esperSpell(27, 10), new esperSpell(28, 2), new esperSpell(32, 1), new esperSpell(26, 2), new esperSpell(9, 3)];
  
  espers[22] = new esper("Odin", "Slices through enemies", 70, "Speed+1");
  espers[22].spells = [new esperSpell(19, 1)];
  
  espers[23] = new esper("Bahamut", "Cuts through magic defenses", 86, "HP + 50%");
  espers[23].spells = [new esperSpell(15, 2)];
  
  //espers[24] = new Object;
  //espers[24].name = "Raiden"
  //espers[24].info = "Slices through enemies"
  //espers[24].mpcost = 80
}

function gainMagicPoints(actor, magicPoints)
{
  if (actor.esper)
  {
    for (var i = 0; i < actor.esper.spells.length; i++)
    {
      if (actor.magic[i].learn != 100)
      {
        var temp = magicPoints * actor.esper.spells[i].learnRate;
        actor.magic[actor.esper.spells[i].spell].learn += temp;
        if (actor.magic[actor.esper.spells[i].spell].learn > 100)
        {
          actor.magic[actor.esper.spells[i].spell].learn = 100;
        }
      }
    }
  }
}

